/*
* drv_dualos.c- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/
/*
 * remote_swla_test.c
 *   control RTOS SWLA
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/types.h>
#include <asm/arch_timer.h>
#include "cam_os_wrapper.h"
#include "drv_dualos.h"

MODULE_AUTHOR("SSTAR");
MODULE_DESCRIPTION("SStar Remote SWLA Test");
MODULE_LICENSE("GPL");

static int __init RemoteSwlaTestInit(void)
{
    u64 curr_ts;
    CamOsPrintf("Set SWLA start!\n");
    remote_sys_swla_start(1);

    CamOsMsSleep(3000);

    curr_ts = arch_counter_get_cntpct();

    CamOsPrintf("Set SWLA stop!\n");
    remote_sys_swla_stop();

    curr_ts = arch_counter_get_cntpct();

    CamOsPrintf("Add SWLA log!\n");
    remote_sys_swla_log_add_event("EvtTest", SS_SWLA_LOG_START, curr_ts - 5000);
    remote_sys_swla_log_add_event("LabTest", SS_SWLA_LOG_LABEL, curr_ts - 3000);
    remote_sys_swla_log_add_event("EvtTest", SS_SWLA_LOG_STOP, curr_ts - 2000);

    //This section need to enable rtos proxyfs
    //CamOsPrintf("Dump SWLA log to /misc/swla_test.log!\n");
    //remote_sys_swla_dump(SS_SWLA_DUMP_FS, "/misc/swla_test.log");

    CamOsPrintf("Dump SWLA log to console!\n");
    remote_sys_swla_dump(SS_SWLA_DUMP_UART, NULL);

    return 0;
}

static void __exit RemoteSwlaTestExit(void)
{
    CamOsPrintf(KERN_INFO "Goodbye\n");
}

module_init(RemoteSwlaTestInit);
module_exit(RemoteSwlaTestExit);
